-- Representacion de diccionarios
-- Dado el tipo siguiente para representar diccionarios donde un string
-- est asociado con un valor
data As a = A String a deriving Show
type Dicc a = [As a]

-- crear un diccionario vacio
creaDicc :: Dicc a
creaDicc = []

-- actualizar una clave y valor. Si la clave no existe, se inserta con el valor. Las claves
-- deben estar ordenadas de menor a mayor.

actualiza :: Dicc a -> String -> a -> Dicc a
actualiza [] c v = [A c v]
actualiza ((A c' v'):xs) c v
	| c' == c = (A c v):xs
	| c' > c  = (A c v):(A c' v'):xs
	| otherwise = (A c' v'):actualiza xs c v

-- devuelve cierto si la clave se encuentra en el diccionario. Debe tener en cuenta
-- que las claves estn ordenadas

esta :: Dicc a -> String -> Bool
esta [] c = False
esta ((A c' v'):xs) c 
	| c'==c     = True
	| c' > c    = False
	| otherwise = esta xs c

-- devuelve el valor asociado a una clave o error si no est. Debe tener en cuenta que las claves 
-- estn ordenadas

valor :: Dicc a -> String -> a
valor [] c = error "La clave no existe"
valor ((A c' v'):xs) c
	| c' == c = v'
	| c' > c  = error "La clave no existe"
	| otherwise = valor xs c

-- Dada una lista de palabras (donde posiblemente hay palabras repetidas) cuenta cuantas 
-- veces aparece cada palabra y lo almacena en un diccionario
ejPal = ["hola","que","hola","tal","como","tal","hola","que","hola","que"]
-- >cuentaPalabras ejPal
-- [A "como" 1,A "hola" 4,A "que" 3,A "tal" 2] 

cuentaPalabras :: [String] -> Dicc Int
cuentaPalabras  = foldr incrementa creaDicc  
			where incrementa p d 
				| esta d p  = actualiza d p (n+1)
				| otherwise = actualiza d p 1
			        where n = valor d p


-- Basada en la funcin anterior, queremos construir una lista de pares en las que aparezca 
-- una palabra y el nmero de veces que aparece, pero ordenado de mayor a menor por el nmero 
-- de apariciones. De manera que
-- >porApariciones ejPal
-- [("hola",4),("que",3),("tal",2),("como",1)]  

porApariciones :: [String] -> [(String,Int)]
porApariciones = aListaPares.ordenaApa.cuentaPalabras
ordenaApa [] = []
ordenaApa [x] = [x]
ordenaApa ((A c v):xs) = ordenaApa [A c' v' | A c' v' <- xs, v' >= v]++
			 (A c v):ordenaApa [A c' v' | A c' v' <- xs, v' < v] 
aListaPares = map (\(A c v) -> (c,v))

--Una encuesta consta de una lista de pares, elprimero contiene una cadena con un nmero que indica el
-- numero de pregunta del test. La segunda componente del par es la respuesta dad a la pregunta. Esta puede ser:
-- nunca, casi nunca, a veces, a menudo, casi siempre, siempre
-- En algunas preguntas, las respuestas pueden ser cadenas conteniendo un valor numrico del 0 al 9

type Encuesta = [(String, String)]
ejen1 = [("1","nunca"),("2","Seat"),("3","a veces"),("4","siempre")]

ejen2 = [("1","siempre"),("2","Mercedes"),("3","a veces"),("5","nunca")]

-- Crear una funcin que tome como resultado una encuesta y un diccionario y acumule los resultados 
-- de la encuesta al diccionario. Para ello, el diccionario debe tener como clave, la cadena
-- que representa el nmero de la pregunta, y como valor, otro diccionario en el que, como clave
-- tiene las posibles respuestas, y como valor el nmero de veces que aparece

-- acum ejen2 [A "1" [A "nunca" 1], A "2" [A "Mercedes" 1]]
-- [A "1" [A "nunca" 1,A "siempre" 1],A "2" [A "Mercedes" 2],A "3" [A "a veces" 1],
--  A "5" [A "nunca" 1]] 

acum:: Encuesta -> Dicc (Dicc Int) -> Dicc (Dicc Int)
acum e dicc = foldr acumula dicc e
		where acumula (p,c) d 
			| esta d p  =  actualiza d p (actualiza di c (n+1))
			| otherwise = actualiza d p (actualiza creaDicc c 1)
			where di = valor d p
			      n  = if (esta di c) then valor di c else 0

-- Crear una funcin que dada una lista de encuestas, produzca como resultado un diccionario donde asociado
-- a cada pregunta de la encuesta, aparezca otro diccionario en el que, asociada a cada respuesta, 
-- aparezca el nmero de veces que esta se produce

-- >resultados [ejen1,ejen2]
-- [A "1" [A "nunca" 1,A "siempre" 1],A "2" [A "Mercedes" 1,A "Seat" 1],
--  A "3" [A "a veces" 2],A "4" [A "siempre" 1],A "5" [A "nunca" 1]]
resultados :: [Encuesta] -> Dicc (Dicc Int)
resultados = foldr acum creaDicc 

